#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This simply shows ten gtk-label entries in a vertical box.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk4/=76_ten_vboxes_example.rb
# =========================================================================== #
require 'gtk4'

::Gtk::Settings.default.gtk_font_name = 'Mono 25'

vbox = Gtk::Box.new(:vertical)

vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 1')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 2')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 3')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 4')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 5')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 6')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 7')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 8')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new(' 9')))
vbox.append(Gtk::Box.new(:horizontal).append(Gtk::Label.new('10')))
vbox.show

application = Gtk::Application.new('org.gtk.ten_vboxes_example', :flags_none)
application.signal_connect(:activate) { |app|
  win = ::Gtk::ApplicationWindow.new(app)
  win.title = 'Showcasing Ten vboxes' 
  win.set_default_size(100, 100)
  win.set_child(vbox)
  win.show
}
application.run