#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk4'

alias e puts

module Gtk

class SpinnerExample < ::Gtk::Box # === Gtk::SpinnerExample

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    'Spinner Example'
  end; alias title title? # === title

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @spinner
    # ======================================================================= #
    @spinner = ::Gtk::Spinner.new
    @spinner.set_spinning(false)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    Thread.new {
      sleep 0.5 # Just to show how to activate it, via a slight delay.
      @spinner.set_spinning(true)
    }
    append(@spinner)
    set_halign(:center)
  end

end; end

application = Gtk::Application.new('org.gtk.spinner_example', :flags_none)
application.signal_connect(:activate) { |app|
  win = Gtk::ApplicationWindow.new(app)
  win.title = 'Showcasing Spinner Example' 
  win.set_default_size(100, 100)
  win.set_child(Gtk::SpinnerExample.new)
  win.show
}
application.run