#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file shows an example how to deal with Gtk::Dialog.
# =========================================================================== #
# require 'gtk_paradise/examples/gtk3/gtk_dialog_sample.rb'
# Gtk::DialogSample.new
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/gtk_dialog_sample.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class DialogSample < ::Gtk::Dialog

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(*optional_widgets_to_add)
    super()
    set_title 'Gtk::Dialog Sample'
    set_default_size(600, 250)
    move(0, 0)
    child.add(
      Gtk::Label.new('Gtk::Dialog Sample')
    )

    entry = Gtk::Entry.new
    entry.show
    child.add(
      entry
    )

    add_button('OK', :ok)
    add_button(::Gtk::Stock::CANCEL, :cancel)
    add_button(::Gtk::Stock::CLOSE,  :close)
    set_default_response(::Gtk::ResponseType::CANCEL)
    signal_connect(:response) { |widget, response|
      case response
      when :ok
        e 'OK'
      when :cancel
        e 'Cancel'
      # ===================================================================== #
      # === :close
      # ===================================================================== #
      when :close, -7
        e 'Close'
        destroy
        Gtk.main_quit
      end
    }
    show_all
    optional_widgets_to_add.flatten.each {|this_widget_is_to_be_added|
      add_this_widget(this_widget_is_to_be_added)
    }
  end

  # ========================================================================= #
  # === add_this_widget
  # ========================================================================= #
  def add_this_widget(i = nil)
    child.add(i) if i
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::DialogSample.new
  Gtk.main
end # rb 029_gtk_dialog_sample.rb