#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# '083_bottom_left_placement.rb'
# =========================================================================== #
require 'gtk3'

module Gtk

class BottomLeftPlacement < ::Gtk::Box

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:vertical)
    set_border_width(6)
    listbox = ::Gtk::ListBox.new
    _ = ::Gtk::ListBoxRow.new
    mini_hbox = ::Gtk::Box.new(:horizontal)
    mini_hbox.add(::Gtk::Label.new('HEY 3 '))
    mini_hbox.add(::Gtk::Button.new(label: 'HEY 3'))
    _.add(mini_hbox)
    listbox.add(_)
    listbox.activate_on_single_click = false
    pack_start(listbox,   expand: true, fill: true, padding: 10)
    alignment = ::Gtk::Alignment.new(0, 1, 0, 0)
    label = ::Gtk::Label.new('bottom-left')
    alignment.add(label)
    pack_start(alignment, expand: true, fill: true, padding: 10)
    alignment = ::Gtk::Alignment.new(0.85, 1, 0, 0) # Place right.
    label = ::Gtk::Label.new('bottom-right')
    alignment.add(label)
    pack_start(alignment, expand: true, fill: true, padding: 10)
    show_all
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.add(Gtk::BottomLeftPlacement.new)
  window.move(0, 0)
  window.show_all
  window.set_size_request(400, 100)
  window.set_title('Bottom left and (almost) bottom right placement')
  window.signal_connect(:delete_event) { Gtk.main_quit }
  Gtk.main  
end