#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This shows how to use the modern search-bar.
# =========================================================================== #
# require 'gtk_paradise/examples/gtk3/008_search_bar_example.rb'
# Gtk::SearchBarExample.new
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/008_search_bar_example.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class SearchBarExample < ::Gtk::Box

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal)
    reset
    run
  end

  # ========================================================================= #
  # === searchbar?
  # ========================================================================= #
  def searchbar?
    @searchbar
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    @searchbar = ::Gtk::SearchBar.new
  end

  # ========================================================================= #
  # === on_key_event
  #
  # Cause the searchbar to show up.
  # ========================================================================= #
  def on_key_event(widget, event)
    shortcut = ::Gtk.accelerator_get_label(event.keyval, event.state)
    # ======================================================================= #
    # Get support for Ctrl+F next:
    # ======================================================================= #
    if ['Ctrl+F', 'Ctrl+Mod2+F'].include? shortcut
      if @searchbar.search_mode?
        @searchbar.set_search_mode(false)
      else
        @searchbar.set_search_mode(true)
      end
    end
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    grid = ::Gtk::Grid.new
    add(grid)

    label = ::Gtk::Label.new('Press Control+F to initiate find')
    grid.attach(label, 0, 0, 1, 1)
    grid.attach(@searchbar, 0, 1, 1, 1)

    @searchentry = ::Gtk::SearchEntry.new
    @searchbar.connect_entry(@searchentry)
    @searchbar.add(@searchentry)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  search_bar_example = ::Gtk::SearchBarExample.new
  window.add(search_bar_example)
  window.set_title('SearchBar')
  window.set_size_request(550, 500)
  window.signal_connect(:destroy) { ::Gtk.main_quit }
  window.show_all
  window.signal_connect(:key_press_event) {|widget, event|
    search_bar_example.on_key_event(widget, event)
  }
  window.move(0, 0)
  Gtk.main
end