#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example shows how to use Gtk::Stack.
# =========================================================================== #
# require '076_stack_example.rb'
# =========================================================================== #
require 'gtk3'

class StackWindow < Gtk::Window
  def initialize
    super('Stack Demo')
    set_border_width(10)

    vbox = Gtk::Box.new(:vertical, 6) # Spacing is 6.
    add(vbox)

    stack = Gtk::Stack.new
    stack.set_transition_type(
      Gtk::Stack::TransitionType::SLIDE_LEFT_RIGHT
    )
    stack.set_transition_duration(1000) # Set the transition-duration here.

    checkbutton = Gtk::CheckButton.new('Click me now!')
    stack.add_titled(checkbutton, "check", "Check Button")

    label = Gtk::Label.new
    label.set_markup('<big>A fancy label</big>')
    stack.add_titled(label, 'label1', 'A label')

    label = Gtk::Label.new
    label.set_markup('And yet another label')
    stack.add_titled(label, 'label2', 'Another label')
    
    stack_switcher = Gtk::StackSwitcher.new
    stack_switcher.set_stack(stack)
    vbox.pack_start(stack_switcher, expand: true, fill: true, padding: 0)
    vbox.pack_start(stack, expand: true, fill: true, padding: 0)
  end
end

win = StackWindow.new
win.signal_connect(:destroy) { Gtk.main_quit }
win.show_all
Gtk.main