#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

Gtk::Settings.default.gtk_font_name = 'Hack 23'

@window = Gtk::Window.new(:toplevel)
@window.title = 'Cursors'
WIDTH_AND_HEIGHT = 850
@window.set_default_size(WIDTH_AND_HEIGHT, WIDTH_AND_HEIGHT)

# =========================================================================== #
# === toplevel_method_uses_this_cursor
# =========================================================================== #
def toplevel_method_uses_this_cursor(cursor, modify_this_window = @window)
  modify_this_window.set_cursor(cursor)
end
  
# =========================================================================== #
# === AVAILABLE_CURSORS
# =========================================================================== #
AVAILABLE_CURSORS = %w(

  all-scroll
  col-resize
  default
  none
  row-resize
  n-resize
  e-resize
  s-resize
  w-resize
  ne-resize
  nw-resize
  se-resize
  sw-resize
  ew-resize
  ns-resize
  nesw-resize
  nwse-resize
  alias
  copy move
  no-drop
  not-allowed
  grab
  grabbing
  context-menu
  help
  pointer
  progress
  wait
  zoom-in
  zoom-out
  cell
  crosshair
  text
  vertical-text

)
# Add a scrolled window next:
scrolled_window = Gtk::ScrolledWindow.new(nil, nil)
scrolled_window.set_policy(:never, :automatic)
@window.add(scrolled_window)
box = Gtk::Box.new(:vertical, 0)
box.margin_start = 20
box.margin_end = 20
box.margin_bottom = 20

section = Gtk::FlowBox.new
section.set_halign(:start)
section.set_selection_mode(:none)
section.set_min_children_per_line(3)

# =========================================================================== #
# === BASE_DIR
#
# You may have to adjust the paths below to your system.
# BASE_DIR = '/usr/share/gtk-doc/html/gdk3/'
# =========================================================================== #
BASE_DIR = '/home/x/Temp/rbt/gtk+-3.24.38/docs/reference/gdk/images/'

AVAILABLE_CURSORS.each {|this_cursor|
  label = Gtk::Label.new(this_cursor)
  label.xalign = 0
  label.margin_top = 10
  label.margin_bottom = 10
  section.add(label)
  # cursor = Gdk::Cursor.new(this_cursor)
  use_this_path = BASE_DIR+
                  this_cursor.to_s.tr('-', '_')+
                  '_cursor.png'
  e 'Path in use: '+use_this_path.to_s
  image = Gtk::Image.new(
    file: use_this_path
  )
  image.set_size_request(32, 32)
  section.add(image)
}
box.add(section)
outer_box = Gtk::Box.new(:horizontal)
box1 = Gtk::Box.new(:horizontal)
box1.add(Gtk::Label.new('Box1 '))
box2 = Gtk::Box.new(:horizontal)
box2.add(Gtk::Label.new('Box2 '))
box3 = Gtk::Box.new(:horizontal)
box3.add(Gtk::Label.new('Box3 '))
box4 = Gtk::EventBox.new
box4.add(Gtk::Label.new('Box4'))
box4.signal_connect(:event) {|widget, event|
  pp event
  pp event.class
}

outer_box.add(box1)
outer_box.add(box2)
outer_box.add(box3)
outer_box.add(box4)
box.add(outer_box)
scrolled_window.add(box)
@window.show_all
@window.move(0, 0)
@window.signal_connect(:delete_event) { Gtk.main_quit }
#@window.window.set_cursor(Gdk::Cursor.new(:watch))
Gtk.main