#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This is a popup example, that is, when you click the right mouse button,
# a context-menu will emerge.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/022_popup_example.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class PopupExample < ::Gtk::Box # === Gtk::PopupExample

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal, 10)
    @label_widget = ::Gtk::Label.new(
      "Hello World\nYou may 'right-click' me\n\n or use <Shift+F10>"
    )
    pack_start(@label_widget, padding: 20)
    # ======================================================================= #
    # First, build up our menu.
    # ======================================================================= #
    @context_menu = ::Gtk::Menu.new
    @context_menu.append(mitem1 = ::Gtk::MenuItem.new(label: 'Test1'))
    @context_menu.append(mitem2 = ::Gtk::MenuItem.new(label: 'Test2'))
    @context_menu.append(mitem3 = ::Gtk::MenuItem.new(label: 'Test3'))
    @context_menu.append(mitem4 = ::Gtk::MenuItem.new(label: 'Test4'))
    @context_menu.append(mitem5 = ::Gtk::MenuItem.new(label: 'Test5'))
    @context_menu.append(mitem6 = ::Gtk::CheckMenuItem.new(label: 'Test6'))
    @context_menu.show_all
    # ======================================================================= #
    # Next, let these menu-items respond to when the user activates them.
    # ======================================================================= #
    mitem1.signal_connect(:activate) { |widget| puts "#{widget.class} - Test1" }
    mitem2.signal_connect(:activate) { |widget| puts "#{widget.class} - Test2" }
    mitem3.signal_connect(:activate) { |widget| puts "#{widget.class} - Test3" }
    mitem4.signal_connect(:activate) { |widget| puts "#{widget.class} - Test4" }
    mitem5.signal_connect(:activate) { |widget| puts "#{widget.class} - Test5" }
  end

  # ========================================================================= #
  # === context_menu?
  # ========================================================================= #
  def context_menu?
    @context_menu
  end; alias context_menu context_menu? # === context_menu

end; end

if __FILE__ == $PROGRAM_NAME
  popup_example = Gtk::PopupExample.new
  window = Gtk::Window.new('A simple example-context-menu')
  # ========================================================================= #
  # Make window sensitive to Right-mouse-click, to open the pop-up menu.
  # window.add_events(:button_press_mask) # ← this is the variant for ruby-gtk3
  # ========================================================================= #
  window.add_events(:button_press_mask) # in gtk-paradise this becomes: add_button_press_events
  # ========================================================================= #
  # Handle right-mouse-button click events:
  # ========================================================================= #
  window.signal_connect(:button_press_event) { |widget, event|
    # ========================================================================= #
    # Note that 'menu' was defined above, as an instance of Gtk::Menu.
    # ========================================================================= #
    if (event.button == 3) # right mouse click event.
      popup_example.context_menu.popup(nil, nil, event.button, event.time)
    end
  }
  # ========================================================================= #
  # Make this window sensitive to <Shift+F10> accelerator keys.
  # These accelerator keys generate the 'popup-menu' signal for
  # the window, which opens the popup-menu.
  # ========================================================================= #
  window.signal_connect(:popup_menu) { |widget|
    # context_menu.popup(nil, nil, 0, Gdk::CURRENT_TIME)
    puts 'shift+F10 was pressed' # This will ONLY show up via shift+F10, and not via right-mouse button click event.
    popup_example.context_menu.popup(nil, nil, 0, Gdk::CURRENT_TIME)
  }
  window.set_default_size(550, 380).show_all
  window.signal_connect(:destroy) { Gtk.main_quit }
  window.add(popup_example)
  window.show_all
  window.move(0, 0)
  Gtk.main
end