#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/change_the_application_theme.rb
# =========================================================================== #
require 'gtk3'

app = Gtk::Application.new('org.xfce-colour.example', :flags_none)

Gtk::Settings.default.set_gtk_theme_name(ARGV.first) if ARGV.first

# =========================================================================== #
# There are other methods, for example:
#
#   Gtk::Settings.default.gtk_application_prefer_dark_theme = true
#
# =========================================================================== #
IMAGE_TO_USE = '/home/x/data/images/SMALL_PLANE.png'
app.signal_connect(:activate) { |a|
  w = Gtk::ApplicationWindow.new(a)
  w.set_title('XFCE Colour')
  w.set_icon(
    IMAGE_TO_USE
  )
  w.set_default_size(70, 70)
  # Arrange the widgets into a grid next.
  g = Gtk::Grid.new
  w.add(g)

  b1 = Gtk::Button.new(label: 'Button')
  g.attach(b1, 0, 0, 1, 1)

  b2 = Gtk::CheckButton.new('')
  g.attach(b2, 1, 0, 1, 1)

  # The Radio button does not appear to work.
  b3 = Gtk::RadioButton.new(label: 'abc')
  g.attach(b3, 2, 0, 1, 1)

  b4 = Gtk::SearchEntry.new
  g.attach(b4, 3, 0, 1, 1)

  b5 = Gtk::ToggleButton.new(label: 'Button')
  g.attach(b5, 0, 1, 1, 1)

  b6 = Gtk::ColorButton.new
  g.attach(b6, 1, 1, 1, 1)

  # class Switch has a strange, small close-button to the right hand side.
  b7 = Gtk::Switch.new
  g.attach(b7, 2, 1, 1, 1)

  b8 = Gtk::Entry.new
  g.attach(b8, 3, 1, 1, 1)

  [b1, b2, b3, b4, b5, b6, b7, b8].each { |b|
    begin
      b.margin = 6
    rescue Exception
      puts $!
    end
  }
  w.show_all
  w.move(0, 0)
}

if __FILE__ == $PROGRAM_NAME
  app.run  
end