#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example will only work on ruby-gtk3.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/popover_example.rb
# =========================================================================== #
require 'gtk3'

class PopoverWindow < Gtk::Window

  Gtk::Settings.default.gtk_font_name = 'DejaVu Sans Mono 22'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    set_title 'Simple Popover Demo'
    set_border_width(25)
    set_default_size(550, 250)
    outerbox = Gtk::Box.new(:vertical, spacing = 8)
    add(outerbox)
    button = Gtk::Button.new(label: 'Click on me')
    button.signal_connect(:clicked) {
      do_reveal_the_popover
    }
    outerbox.pack_start(button, fill: false, expand: true, padding: 0)
    # Create the popover next.
    @popover = Gtk::Popover.new
    vbox = Gtk::Box.new(:vertical)
    vbox.pack_start(
      Gtk::Label.new(label = 'Example'),
      fill: false, expand: true, padding: 10
    )
    @popover.add(vbox)
    @popover.set_position(:bottom)
    @popover.set_relative_to(button)
    @popover.show_all
  end

  # ========================================================================= #
  # === do_reveal_the_popover
  # ========================================================================= #
  def do_reveal_the_popover
    @popover.popup
  end

end

if __FILE__ == $PROGRAM_NAME
  win = PopoverWindow.new
  win.signal_connect(:destroy) { Gtk.main_quit }
  win.move(0, 0)
  win.show_all
  Gtk.main
end