#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Loosely modelled after:
#
#   https://pypi.org/project/pygtk-form/
#
# =========================================================================== #
# require 'gtk_paradise/examples/gtk3/form_example.rb'
# =========================================================================== #
require 'gtk3'

# =========================================================================== #
# === USE_THIS_AS_THE_CSS_STRING
# =========================================================================== #
USE_THIS_AS_THE_CSS_STRING = <<-EOF

button {
  background-image: none;
  background-color: yellow;
  color: black;
  border: 15px solid royalblue;
}

/* The following two do not seem to work. */
combobox {
  border-radius: 0;
}

comboboxtext {
  border-radius: 0;
}

button:hover {
	border-color:  green;
	outline-color: red;
}

/* Add a lot of padding, just to make it clearer what is happening: */
box.container {
  padding: 50px;
}

/* Modify the labels, unless they are a form_title */
box.container>label:not(.form_title) {
  margin-top: 15px;
}

#big_label {
  padding: 20px;
  font-size: 2em;
}

#entry_for_the_username {
  border: 2px solid black;
	border-radius: 3px;
}

#entry_for_the_username:hover {
	border-color:  green;
	outline-color: red;
}

box.validation_container {
  padding: 10px;
  padding-top: 5px;
}

EOF

Gtk::Settings.default.gtk_font_name = 'DejaVu Sans Mono 24'

application = Gtk::Application.new
application.signal_connect(:activate) {
  # ========================================================================= #
  # We have to pass the CSS into Gtk::CssProvider. We will pass the
  # above-defined constant to this.
  # ========================================================================= #
  provider = Gtk::CssProvider.new
  provider.load(data: USE_THIS_AS_THE_CSS_STRING)
  Gtk::StyleContext.add_provider_for_screen(
    Gdk::Screen.default,
    provider,
    Gtk::StyleProvider::PRIORITY_APPLICATION
  )

  window = Gtk::ApplicationWindow.new(application)
  window.set_size_request(700, 600)

  entry_example1 = Gtk::Entry.new
  entry_example1.set_name('lightgreen_background') 

  box = Gtk::Box.new(:vertical)
  box.style_context.add_class('container')

  button = Gtk::Button.new(text: 'This is a test-button')
  box.add(button)

  label = Gtk::Label.new('<b>Cool form</b>')
  label.use_markup = true
  label.set_name('big_label')
  box.add(label)

  box.add(entry_example1)

  box.add(
    Gtk::Label.new('Make a choice next:')
  )

  combo_box = Gtk::ComboBoxText.new # (entry: true)
  %w( foo bar bla ).each {|entry|
    combo_box.append_text(entry.to_s)
  }
  box.add(combo_box)

  box.add(
    Gtk::Label.new('Your username')
  )
  entry_for_the_username = Gtk::Entry.new
  entry_for_the_username.set_name('entry_for_the_username')
  box.add(
    entry_for_the_username
  )

  box.add(
    Gtk::Label.new('What distribution do you use?')
  )

  combo_box = Gtk::ComboBoxText.new # (entry: true)
  (
    %w( Fedora Ubuntu Debian Manjaro )+['Arch (BTW)']
  ).flatten.each {|entry|
    combo_box.append_text(entry.to_s)
  }
  combo_box.active = 3
  if combo_box.child.respond_to? :text=
    combo_box.child.text = 'Make your selection here'
  end
  box.add(combo_box)
  # add a spacer next 
  spacer = Gtk::Box.new(:vertical)
  box.pack_start(spacer, expand: true, fill: true, padding: 0)

  window << box
  window.show_all
  window.move(0, 0)
}
application.run