#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

# =========================================================================== #
# === USE_THIS_AS_THE_CSS_STRING
# =========================================================================== #
USE_THIS_AS_THE_CSS_STRING = <<-EOF

button {
  background-image: none;
  background-color: yellow;
}

label {
  font-size:  35px;
  font-weight: 800;
  color: steelblue;
}

button:hover {
  background-color: cyan;
}

button:hover label {
  color: blue;
}

button:active {
  background-color: green;
}

button:active label {
  color: white;
}

#yellow_background {
  background: yellow;
}

#lightgreen_background {
  background: lightgreen;
}

#button1 {
  background-image: -gtk-gradient (linear,
                                   left top,left bottom,
                                   from (#d0e4f7),
                                   color-stop (0.1, darker (#d0e4f7)), to (#fdffff));
}

/* Use a fancy background */
window {
  background: linear-gradient(153deg, #151515, #151515 5px, transparent 5px) 0 0,
              linear-gradient(333deg, #151515, #151515 5px, transparent 5px) 10px 5px,
              linear-gradient(153deg, #222, #222 5px, transparent 5px) 0 5px,
              linear-gradient(333deg, #222, #222 5px, transparent 5px) 10px 10px,
              linear-gradient(90deg, #1b1b1b, #1b1b1b 10px, transparent 10px),
              linear-gradient(#1d1d1d, #1d1d1d 25%, #1a1a1a 25%, #1a1a1a 50%, transparent 50%, transparent 75%, #242424 75%, #242424);
  background-color: #131313;
  background-size: 20px 20px;
}

.fancy_styling {
  font-size:     50px;
  border:         8px solid darkgreen;
  border-radius: 32px;
}

EOF

FOR_N_SECONDS = 3
application = Gtk::Application.new
application.signal_connect(:activate) {
  # ========================================================================= #
  # We have to pass the CSS into Gtk::CssProvider. We will pass the
  # above-defined constant to this.
  # ========================================================================= #
  provider = Gtk::CssProvider.new
  provider.load(data: USE_THIS_AS_THE_CSS_STRING)
  Gtk::StyleContext.add_provider_for_screen(
    Gdk::Screen.default,
    provider,
    Gtk::StyleProvider::PRIORITY_APPLICATION
  )

  window = Gtk::ApplicationWindow.new(application)
  window.set_size_request(580, 440)

  entry_example1 = Gtk::Entry.new
  entry_example1.set_text("The delay in use is: #{FOR_N_SECONDS} seconds")
  entry_example1.set_size_request(500, 50)
  entry_example1.set_name('lightgreen_background') # Use that css-class.
  entry_example1.signal_connect(:event) {|widget, event|
    if event.is_a?(Gdk::EventButton) and (event.event_type.name == 'GDK_BUTTON_PRESS')
      case event.button
      when 1
        e 'The left-mouse-button was clicked.'
      when 2
        e 'The middle-mouse-button was clicked.'
      when 3 # Handle the right-mouse button click-event here.
        e 'The right-mouse-button was clicked.'
        entry_example1.set_name('yellow_background')
        Thread.new {
          sleep FOR_N_SECONDS # This "reinstates" the old colour.
          entry_example1.set_name('lightgreen_background') # Use another background.
        }
      end
    end
  }

  fixed = Gtk::Fixed.new
  fixed.put(
    Gtk::Label.new('Click the right-mouse-button in the gtk-entry below.'),
    8, 8
  )
  fixed.put(entry_example1, 220, 110)
  button1 = Gtk::Button.new(label: 'button1')
  button1.set_name('button1')
  fixed.put(button1, 330, 220)
  # style_context.add_class('fancy_styling')
  button2 = Gtk::Button.new(label: 'button2')
  button_context = button2.style_context
  button_context.add_class('fancy_styling')
  fixed.put(button2, 420, 270)
  window << fixed
  window.show_all
  window.move(0, 0)
}
application.run