#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/notebook_css_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

# =========================================================================== #
# === USE_THIS_AS_THE_CSS_STRING
# =========================================================================== #
USE_THIS_AS_THE_CSS_STRING = <<-EOF

.my_notebook tab {
  background: none;
  background-color: honeydew;
}

button {
  background-image: none;
  background-color: yellow;
}

#label1 {
  font-size:     30px;
  font-weight:   600;
  color:         darkblue;
  border:        1px dotted black;
  border-radius: 22px;
  padding:       25px;
}

#lightgreen_background {
  background: lightgreen;
}

#yellow_background {
  background: yellow;
}

notebook {
  border: 3px solid orange;
}

notebook header {
  background: none;
  color:      green;
  border:     2px dotted royalblue;
}

notebook tabs {
  background-image: none;
  background-color: transparent;
  color:    green;
  border:   2px dotted royalblue;
}

notebook tab:active {
  background: none;
  border-color: shade (green, 0.82);
  border-style: solid;
  border-width: 1px;
  background-color: shade (green, 1.02);
  background-image: none;
  /*box-shadow: inset 0 1px shade (green, 1.1);*/
   color: steelblue;
}

.my_notebook tab:active {
  background: none;
  background-color: lightblue;
  border: 5px solid black;
}

notebook tab:nth-child(4) {
  background: none;
  color: orange;
  padding: 10px;
  background-color: blue;
  border: 15px solid black;
}

EOF

application = Gtk::Application.new
application.signal_connect(:activate) {
  # ========================================================================= #
  # We have to pass the CSS into Gtk::CssProvider. We will pass the
  # above-defined constant to this.
  # ========================================================================= #
  provider = Gtk::CssProvider.new
  provider.load(data: USE_THIS_AS_THE_CSS_STRING)
  Gtk::StyleContext.add_provider_for_screen(
    Gdk::Screen.default,
    provider,
    Gtk::StyleProvider::PRIORITY_APPLICATION
  )

  window = Gtk::ApplicationWindow.new(application)
  window.set_size_request(1080, 680)

  fixed = Gtk::Fixed.new
  label = Gtk::Label.new(
    'This script shows how to style a '\
    'Gtk::Notebook instance via CSS.'
  )
  label.set_name('label1')
  fixed.put(
    label,
    5, 500
  )
  notebook = Gtk::Notebook.new
  notebook.set_show_tabs(true)
  notebook.set_show_border(true)
  notebook.set_scrollable(true)
  notebook_context = notebook.style_context
  notebook_context.add_class('my_notebook')
  notebook.set_size_request(700, 400)
  notebook.append_page(Gtk::Label.new('Content 1'), ::Gtk::Label.new('Tab 1'))
  notebook.append_page(Gtk::Label.new('Content 2'), ::Gtk::Label.new('Tab 2'))
  notebook.append_page(Gtk::Label.new('Content 3'), ::Gtk::Label.new('Tab 3'))
  notebook.append_page(Gtk::Label.new('Content 4'), ::Gtk::Label.new('Tab 4'))
  notebook.append_page(Gtk::Label.new('Content 5'), ::Gtk::Label.new('Tab 5'))

  fixed.put(notebook, 20, 50)

  window << fixed
  window.show_all
  window.move(0, 0)
}
application.run