require 'gtk3'

module Gtk

class CalendarExample < ::Gtk::Box

  ::Gtk::Settings.default.gtk_font_name = 'Sans 25'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal)
    reset
    @date = Time.new
    calendar = ::Gtk::Calendar.new
    calendar.select_month(@date.month, @date.year)
    calendar.select_day(@date.day)
    calendar.mark_day(@date.day)
    add(calendar)
    show_all
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    set_border_width(12)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.add(Gtk::CalendarExample.new)
  window.show_all
  window.set_size_request(600, -1)
  window.move(0, 0)
  window.signal_connect(:delete_event) { Gtk.main_quit }
  Gtk.main  
end