#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

COLORS = %w(AliceBlue AntiqueWhite AntiqueWhite1 AntiqueWhite2 AntiqueWhite3
            AntiqueWhite4 aqua aquamarine aquamarine1 aquamarine2 aquamarine3
            aquamarine4 azure azure1 azure2 azure3 azure4 beige bisque bisque1
            bisque2 bisque3 bisque4 black BlanchedAlmond blue blue1 blue2
            blue3 blue4 BlueViolet brown brown1 brown2 brown3 brown4 burlywood
            burlywood1 burlywood2 burlywood3 burlywood4 CadetBlue CadetBlue1
            CadetBlue2 CadetBlue3 CadetBlue4 chartreuse chartreuse1 chartreuse2
            chartreuse3 chartreuse4 chocolate chocolate1 chocolate2 chocolate3
            chocolate4 coral coral1 coral2 coral3 coral4)

class FlowBoxWindow < Gtk::Window

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super
    set_border_width(10)
    set_default_size(300, 250)

    header = Gtk::HeaderBar.new
    header.title = "Flow Box"
    header.subtitle = "Sample FlowBox app"
    header.show_close_button = true

    set_titlebar(header)

    scrolled = Gtk::ScrolledWindow.new
    scrolled.set_policy(:never, :automatic)

    flowbox = Gtk::FlowBox.new
    flowbox.valign = :start
    flowbox.max_children_per_line = 30
    flowbox.selection_mode = :none

    COLORS.each { |color|
      swatch = create_colour_swatch(color)
      flowbox.add swatch
    }
    scrolled.add(flowbox)
    add(scrolled)

    signal_connect(:destroy) { Gtk.main_quit }
  end

  # ========================================================================= #
  # === create_colour_swatch
  # ========================================================================= #
  def create_colour_swatch(color_name)
    color = Gdk::RGBA.parse(color_name)
    button = Gtk::Button.new
    area = Gtk::DrawingArea.new
    area.set_size_request(24, 24)
    area.signal_connect(:draw) { |_, context|
      context.set_source_rgba(color)
      context.paint
    }
    button.add(area)
  end; private :create_colour_swatch

end

win = FlowBoxWindow.new
win.show_all
win.move(0, 0)
Gtk.main