#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

names = %w( Andrew Tim Samantha Jonathan Joe )

window = Gtk::Window.new
window.opacity = 0.9
window.set_border_width(10)
window.set_size_request(800, -1)
window.move(0, 0)

box = Gtk::Box.new(:vertical)

names.each {|name|
  button = Gtk::Button.new(label: name, use_underline: true)
  box.pack_start(
    button, expand: true, fill: true, padding: 5
  )
  button.signal_connect(:clicked) {
    e "Hello #{name}!"
  }
  button.set_relief(:normal)
}

window.add(box)
window.show_all
window.signal_connect(:delete_event) { Gtk.main_quit }
Gtk.main