#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/button_demo.rb
# =========================================================================== #
require 'gtk3'

class ButtonWindow < Gtk::Window

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    set_title 'Button Demo (border-width: 15)'
    set_border_width(15)

    @hbox = Gtk::Box.new(:horizontal, spacing = 6)

    button = Gtk::Button.new(label: 'Click Me')
    button.signal_connect(:clicked) { on_click_me_clicked }
    @hbox.pack_start(button)

    button = Gtk::Button.new(icon_name: 'gtk-open')
    button.signal_connect(:clicked) { e 'Just a button with an image.' }
    @hbox.pack_start(button)
    
    button = Gtk::Button.new(mnemonic: '_Open')
    button.signal_connect(:clicked) { on_open_clicked }
    @hbox.pack_start(button)

    button = Gtk::Button.new(mnemonic: '_Close')
    button.signal_connect(:clicked) { on_close_clicked }
    @hbox.pack_start(button)

    new_vbox = Gtk::Box.new(:vertical)
    button_dont_expand = Gtk::Button.new(mnemonic: '_No Expand')
    button_dont_expand.set_hexpand(false)
    # button_dont_expand.set_halign(Gtk::Alignment::CENTER)
    button_dont_expand.set_xalign(0.5)
    button_dont_expand.set_vexpand(false)
    # button_dont_expand.set_valign(Gtk::Alignment::CENTER)
    button_dont_expand.signal_connect(:clicked) {
      e 'This button will not expand upon resizing.'
    }
    new_vbox.add(button_dont_expand)
    @hbox.pack_start(new_vbox)
    connect_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    add(@hbox)
  end

  # ========================================================================= #
  # === on_click_me_clicked
  # ========================================================================= #
  def on_click_me_clicked
    puts '"Click me" button was clicked'
  end

  # ========================================================================= #
  # === on_open_clicked
  # ========================================================================= #
  def on_open_clicked
    puts '"Open" button was clicked'
  end

  # ========================================================================= #
  # === on_close_clicked
  # ========================================================================= #
  def on_close_clicked
    puts 'Closing application'
    Gtk.main_quit
  end

end

if __FILE__ == $PROGRAM_NAME
  window = ButtonWindow.new
  window.signal_connect(:destroy) { Gtk.main_quit }
  window.set_size_request(720, 75)
  window.signal_connect(:delete_event) { Gtk.main_quit }
  window.move(0, 0)
  window.show_all
  Gtk.main
end