#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

window = Gtk::Window.new(:toplevel)
window.title = 'App Chooser Button Example'

label = Gtk::Label.new('Mail:')
label.halign = :start
label.valign = :center
label.hexpand = :true

use_this_scheme_handler = 'x-scheme-handler/mailto' # 'x-scheme-handler/trash'

picker = Gtk::AppChooserButton.new(use_this_scheme_handler)
picker.show_dialog_item = true

box = Gtk::Box.new(:vertical)
box.add(label)
box.add(picker)

window.add(box)
window.show_all
window.move(0, 0)
window.signal_connect(:delete_event) { Gtk.main_quit }
Gtk.main