#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ListBoxExample
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/015_list_box_example.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class ListBoxExample < ::Gtk::Box

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal)
    scrolled = ::Gtk::ScrolledWindow.new
    scrolled.set_policy(:always, :always)
    pack_start(scrolled, expand: true, fill: true, padding: 0)
    listbox = ::Gtk::ListBox.new
    _ = ::Gtk::ListBoxRow.new
    mini_hbox = ::Gtk::Box.new(:horizontal)
    mini_hbox.add(::Gtk::Label.new('HEY 1 '))
    mini_hbox.add(::Gtk::Button.new(label: 'HEY 1'))
    _.add(mini_hbox)
    listbox.add(_)
    _ = ::Gtk::ListBoxRow.new
    mini_hbox = ::Gtk::Box.new(:horizontal)
    mini_hbox.add(::Gtk::Label.new('HEY 2 '))
    mini_hbox.add(::Gtk::Button.new(label: 'HEY 2'))
    _.add(mini_hbox)
    listbox.add(_)
    _ = ::Gtk::ListBoxRow.new
    mini_hbox = ::Gtk::Box.new(:horizontal)
    mini_hbox.add(::Gtk::Label.new('HEY 3 '))
    mini_hbox.add(::Gtk::Button.new(label: 'HEY 3'))
    _.add(mini_hbox)
    listbox.add(_)
    # ======================================================================= #
    # listbox.set_sort_func { |a, b| a.sort(b) }
    # ======================================================================= #
    listbox.activate_on_single_click = false
    # ======================================================================= #
    # listbox.signal_connect("row-activated", &:row_activated)
    # ======================================================================= #
    scrolled.add(listbox)
    show_all
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.add(Gtk::ListBoxExample.new)
  window.move(0, 0)
  window.show_all
  window.set_size_request(400, 100)
  window.signal_connect(:destroy) { Gtk.main_quit }
  Gtk.main  
end