#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/image_example.rb
# =========================================================================== #
require 'gtk3'

window = Gtk::Window.new

# =========================================================================== #
# === Path to the image
#
# Specify the path to your image here; this is for my home system, so
# change accordingly to your system, please. Alternatively simply
# provide an argument to this file, aka ARGV[1].
# =========================================================================== #
if ARGV[1]
  target_file = ARGV[1]
else
  target_file = '/home/x/data/images/PC/EDITORS/BLUEFISH/BLUEFISH.png'
end

# =========================================================================== #
# The new API for Gtk::Image in ruby-gtk3 is:
#
#   Gtk::Image#initialize(
#     stock: nil,
#     icon_name: nil,
#     icon_set: nil,
#     icon: nil,
#     file: nil,
#     pixbuf: nil,
#     animation: nil,
#     surface: nil,
#     size: nil
#   )
#
# =========================================================================== #
image = Gtk::Image.new(file: target_file, size: :button)
# image = image.resize(25, 25)

# =========================================================================== #
# Or use:
#   image.set_from_file(target_file)
# =========================================================================== #

window.add(image)
window.set_border_width(50)
window.show_all
window.move(0, 0)
window.signal_connect(:destroy) { Gtk.main_quit }

Gtk.main