#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This shows an image using Gdk::Pixbuf.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk2/show_image.rb
# =========================================================================== #
require 'gtk2'

filename = ARGV.first

unless filename
  puts "ruby #{$0} filename"
  exit(1)
end

pixbuf = GdkPixbuf::Pixbuf.new(file: filename)

w = Gtk::Window.new
w.set_size_request(500, 500)
w.realize
w.signal_connect(:delete_event) { Gtk.main_quit }
# Draw that image onto a DrawingArea instance next.
drawing_area = Gtk::DrawingArea.new

gc = Gdk::GC.new(w.window)
drawing_area.signal_connect(:expose_event) { |widget, e|
  unless e.count > 0
    width  = w.allocation.width
    height = w.allocation.height
    pixbuf = pixbuf.scale(width, height)
    # The dither seems to blur it slightly.
    drawing_area.window.draw_pixbuf(gc, pixbuf, 0, 0, 0, 0,
      width, height, Gdk::RGB::DITHER_NORMAL, 0, 0
    )
  end
  true
}
w.add(drawing_area)
w.show_all
Gtk.main # show_image $IMG/RPG/YINYANG_FAVICON.png