#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

class ButtonBox < Gtk::Window

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super('Button Boxes')
    set_border_width(10)

    main_vbox = Gtk::VBox.new(false, 0)
    add(main_vbox)

    frame_horizontal = Gtk::Frame.new('Horizontal Button Boxes')
    main_vbox.pack_start(frame_horizontal, true, true, 10)

    vbox = Gtk::VBox.new(false, 0)
    vbox.set_border_width(10)
    frame_horizontal.add(vbox)

    # ======================================================================= #
    # === Spread
    # ======================================================================= #
    vbox.pack_start(
        create_bbox(true, 'Spread', 8, Gtk::ButtonBox::SPREAD),
        true, true, 0)

    # ======================================================================= #
    # === Edge
    # ======================================================================= #
    vbox.pack_start(
        create_bbox(true, 'Edge', 8, Gtk::ButtonBox::EDGE),
        true, true, 5)

    # ======================================================================= #
    # === Start
    # ======================================================================= #
    vbox.pack_start(
        create_bbox(true, 'Start', 8, Gtk::ButtonBox::START),
        true, true, 5)

    # ======================================================================= #
    # === End
    # ======================================================================= #
    vbox.pack_start(
        create_bbox(true, 'End', 8, Gtk::ButtonBox::END),
        true, true, 5)

    frame_vert = Gtk::Frame.new('Vertical Button Boxes')
    main_vbox.pack_start(frame_vert, true, true, 10)

    hbox = Gtk::HBox.new(false, 0)
    hbox.set_border_width(10)
    frame_vert.add(hbox)

    hbox.pack_start(
        create_bbox(false, 'Spread', 30, Gtk::ButtonBox::SPREAD),
        true, true, 0)

    hbox.pack_start(
        create_bbox(false, 'Edge', 30, Gtk::ButtonBox::EDGE),
        true, true, 5)

    hbox.pack_start(
        create_bbox(false, 'Start', 30, Gtk::ButtonBox::START),
        true, true, 5)

    hbox.pack_start(
        create_bbox(false, 'End', 30, Gtk::ButtonBox::END),
        true, true, 5)

    move(0, 0)
  end

  # ========================================================================= #
  # === create_bbox
  # ========================================================================= #
  def create_bbox(
      horizontal, title, spacing, layout
    )
    frame = Gtk::Frame.new(title)

    if horizontal
      bbox = Gtk::HButtonBox.new
    else
      bbox = Gtk::VButtonBox.new
    end

    bbox.set_border_width(5)
    frame.add(bbox)

    bbox.layout_style = layout # For example: Gtk::ButtonBox::SPREAD
    bbox.set_spacing(spacing)

    [
      Gtk::Stock::OK,
      Gtk::Stock::CANCEL,
      Gtk::Stock::HELP,
      Gtk::Stock::SAVE
     ].each { |stock|
      button = Gtk::Button.new(stock)
      button.signal_connect(:clicked) {
        e "#{stock} was clicked."
      }
      bbox.add(button)
    }
    return frame
  end

end

if __FILE__ == $PROGRAM_NAME
  ButtonBox.new.show_all
  Gtk.main
end