#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

list_store = Gtk::ListStore.new(String, Integer)
column1 = Gtk::TreeViewColumn.new('data1', Gtk::CellRendererText.new, {text: 0})
column2 = Gtk::TreeViewColumn.new('data2', Gtk::CellRendererText.new, {text: 1})

# =========================================================================== #
# Set up our filter next:
# =========================================================================== #
tree_model_filter = Gtk::TreeModelFilter.new(list_store)
tree_model_filter.set_visible_func { |model, iter|
  # ========================================================================= #
  # This regex will either return nil, or the match, such as 'bbc'.
  # ========================================================================= #
  result = (/a/ =~ iter[0]) # Match it against the first iter element.
  result
}

tree_model_filter.set_modify_func(String, String) { |model, iter, column|
  child_iter = model.convert_iter_to_child_iter(iter)
  if column == 0
    # This is the column on the very first side, left hand.
    child_iter[0]
  else
    # And this is on the right side. 
    "#{child_iter[1]} * 2 = #{child_iter[1] * 2}"
  end
}

treeview = Gtk::TreeView.new(tree_model_filter)
treeview.append_column(column1)
treeview.append_column(column2)
treeview.selection.set_mode(Gtk::SelectionMode::MULTIPLE)
# =========================================================================== #
# Our array-dataset is quite regular: 3 chars on the left side, and a simple 
# integer-numbe on the right side. Note that we defined 6 elements here 
# in this Array, but the filter will remove 2 of these 6, so we only 
# end up seeing four entries.
# =========================================================================== #
array = [
  ['aaa', 1],
  ['aab', 2],
  ['aac', 3],
  ['bba', 4],
  ['bbb', 5],
  ['bbc', 6]
]
array.each { |string, number|
  iter = list_store.append
  iter[0] = string
  iter[1] = number
}
window = Gtk::Window.new
window.set_size_request(800, 800)
window.add(treeview).show_all.signal_connect(:destroy){Gtk.main_quit}
Gtk.main # $RUBY_GTK/tree_model_filter.rb