#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# 'accel_group_example.rb'
# =========================================================================== #
require 'gtk2'

window = Gtk::Window.new
@accel_group = Gtk::AccelGroup.new
window.add_accel_group(@accel_group)
@entry = Gtk::Entry.new
@accel_group.connect( Gdk::Keyval::GDK_W, :mod1_mask, :visible) { # CONTROL_MASK ist strg
  puts 'They alt+w combination was pressed.'
  @entry.set_text('The key was pressed')
}
box = Gtk::HBox.new
box.add(Gtk::Label.new('Press alt+w key combination '))
box.add(@entry)
window.add(box)
window.show_all
window.set_size_request(600, 50)
window.move(0, 0)
Gtk.main