#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This is an example for frames containing elements that can be reparented.
# =========================================================================== #
require 'gtk2'

# =========================================================================== #
# === SWITCH_TEXT
# =========================================================================== #
SWITCH_TEXT = 'switch here to (will use .reparent)'

::Gtk::Settings.default.gtk_font_name = 'Mono 18'

window = Gtk::Window.new('buttons')
window.signal_connect(:destroy) { Gtk.main_quit }
window.border_width = 0

vbox = Gtk::VBox.new(false, 0)

box2 = Gtk::HBox.new(false, 5)
box2.set_border_width(10)
vbox.pack_start(box2, true, true, 0)

label = Gtk::Label.new('Hello World')

TITLE_FOR_FRAME1 = 'Frame 1'
frame1 = Gtk::Frame.new(TITLE_FOR_FRAME1)
frame1.label_widget.set_markup(
  '<span weight="bold" size="xx-large" foreground="steelblue">'+TITLE_FOR_FRAME1+'</span>'
)
box2.pack_start(frame1, true, true, 0)

framebox1 = Gtk::VBox.new(false, 5)
framebox1.border_width = 5
frame1.add(framebox1)

button = Gtk::Button.new(SWITCH_TEXT)
button.signal_connect(:clicked){
  label.reparent(framebox1)
}
framebox1.pack_start(button, false, true, 0)

framebox1.add(label)
# This signal gets triggered when re-parenting is done.
label.signal_connect('parent_set'){ |child, old_parent|
  puts "set_parent for \"#{child.class}\":"
  puts " new parent: \"#{if child.parent then child.parent.class else 'NULL' end}\","
  puts " old parent: \"#{if old_parent then old_parent.class else 'NULL' end}\","
}

TITLE_FOR_FRAME2 = 'Frame 2'
frame2 = Gtk::Frame.new(TITLE_FOR_FRAME2)
frame2.label_widget.set_markup(
  '<span weight="bold" size="xx-large" foreground="steelblue">'+TITLE_FOR_FRAME2+'</span>'
)
box2.pack_start(frame2, true, true, 0)

framebox2 = Gtk::VBox.new(false, 5)
framebox2.border_width = 5
frame2.add(framebox2)

button = Gtk::Button.new(SWITCH_TEXT)
button.signal_connect(:clicked){
  label.reparent(framebox2)
}
framebox2.pack_start(button, false, true, 0)

vbox.pack_start(Gtk::HSeparator.new, false, true)

button = Gtk::Button.new('close')
button.signal_connect(:clicked) { Gtk.main_quit }
vbox.pack_start(button, false, true, 10)
button.can_default = true
button.grab_default

window.add(vbox)
window.show_all
window.set_size_request(800, 150)
window.move(0, 0)
Gtk.main