#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/complete_menu_example.rb'
# =========================================================================== #
require 'gtk2'

alias e puts

# =========================================================================== #
# Describe the structure of the menu next, via XML:
# =========================================================================== #
MENU_UI_DESIGN_XML = %Q[
<ui>
  <menubar name='MenuBar'>
    <menu action='FileMenu'>
        <separator />
        <menuitem action='New' />
        <separator />
        <menuitem action='Quit' />
        <separator />
    </menu>
  </menubar>
</ui>
]

@callback = Proc.new {|actiongroup, action|
  e "`#{action.name}` is clicked."
}
@callback_quit = Proc.new {
  exit_the_program
}

# =========================================================================== #
# === MENU_ACTIONS
#
# This Array describes the actions associated with the above-defined
# XML layout.
# =========================================================================== #
MENU_ACTIONS = [
  ['FileMenu', nil, '_File'],
  ['Quit', Gtk::Stock::QUIT, '_Quit', '<control>Q', 'Quit',
    @callback_quit
  ],
  ['New',  Gtk::Stock::NEW,  '_New',  '<control>N',  'Create a new file',
    @callback
  ]
]

# =========================================================================== #
# === exit_the_program
# =========================================================================== #
def exit_the_program
  e 'Quit is called.'
  Gtk.main_quit
end

@main_window = Gtk::Window.new
@main_window.move(0, 0)
@action_group = Gtk::ActionGroup.new('Actions')
@action_group.add_actions(MENU_ACTIONS)

@ui_manager = Gtk::UIManager.new
@ui_manager.insert_action_group(@action_group, 0)
@ui_manager.add_ui(MENU_UI_DESIGN_XML)

@main_window.add_accel_group( @ui_manager.accel_group )

@v_box = Gtk::VBox.new
@v_box.pack_start(@ui_manager['/MenuBar'], false, false)

@main_window.add(@v_box)
@main_window.set_default_size(200, 200).show_all
@main_window.signal_connect(:destroy){Gtk.main_quit}
Gtk.main # $RUBY_GTK/gtk2_menu.rb