#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

alias e puts

# =========================================================================== #
# Specify the base-directory with your images next:
# =========================================================================== #
if ARGV and (ARGV.size > 0)
  BASE_DIR = ARGV.first
else
  BASE_DIR = '/home/x/data/images/STD/'
end
IMG_DIR = BASE_DIR+'*.png'
e 'Reading in from the directory '+BASE_DIR

TEXT_COLUMN= 0
PIXBUF_COLUMN = 1
model = Gtk::ListStore.new(String, GdkPixbuf::Pixbuf)
 
iv = Gtk::IconView.new(model)
iv.text_column = TEXT_COLUMN
iv.pixbuf_column = PIXBUF_COLUMN

Dir[IMG_DIR+'*'].each { |f|
  iter = model.append
  iter[TEXT_COLUMN]= File.basename(f)
  iter[PIXBUF_COLUMN] = GdkPixbuf::Pixbuf.new(file: f)
}

iv.signal_connect(:item_activated) {|iv, path| # Doppelcklick
  iter = model.get_iter(path)
  filename = iter[0]
  efile BASE_DIR+filename
}
 
if __FILE__ == $PROGRAM_NAME
  scrolled_window = Gtk::ScrolledWindow.new
  scrolled_window.add_with_viewport(iv)
  scrolled_window.show_all
  window = Gtk::Window.new
  window.add(scrolled_window)
  window.show_all
  window.set_size_request(800, 800)
  window.move(0, 0)
  Gtk.main
end # $RUBY_GTK/icon_view.rb