#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This code shows an example how to work with radio-buttons in gtk3.
# =========================================================================== #
# require 'radio_button_window.rb'
# =========================================================================== #
require 'gtk2'

class RadioButtonWindow < Gtk::Window

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    ::Gtk::Settings.default.gtk_font_name = 'Sans 26'
    set_title('RadioButton Demo')
    set_border_width(15)

    hbox = Gtk::HBox.new
    add(hbox)

    button1 = Gtk::RadioButton.new('Button 1')
    button1.signal_connect(:toggled) { |b| on_button_toggled b, 1 }
    hbox.pack_start(button1)

    button2 = Gtk::RadioButton.new(button1, 'Button 2')
    button2.signal_connect(:toggled) { |b| on_button_toggled b, 2 }
    hbox.pack_start(button2)

    button3 = Gtk::RadioButton.new(button1, 'B_utton 3', true)
    button3.signal_connect(:toggled) { |b| on_button_toggled b, 3 }
    hbox.pack_start(button3)
  end

  # ========================================================================= #
  # === on_button_toggled
  # ========================================================================= #
  def on_button_toggled(button, name)
    state = button.active? ? 'on' : 'off'
    e "Button #{name} was turned #{state}"
  end

end

if __FILE__ == $PROGRAM_NAME
  win = RadioButtonWindow.new
  win.signal_connect(:destroy) { Gtk.main_quit }
  win.set_size_request(800, 150)
  win.show_all
  win.move(0, 0)
  Gtk.main
end