#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This code will "draw" a small rectangle. Note that gtk_paradise offers
# a simplified way to use colours, rather than via set_source_rgb()
# directly - but the examples here need to remain "standalone", e. g.
# without any modifications by gtk_paradise.
#
# See also:
#
#   require 'gtk_paradise/core_classes/cairo/context.rb'
#
# =========================================================================== #
# draw_rectangles.rb'
require 'gtk2'

window = Gtk::Window.new
vbox = Gtk::VBox.new
@drawing_area = Gtk::DrawingArea.new
@drawing_area.set_size_request(200, 200)
@drawing_area.has_tooltip = true
@drawing_area.signal_connect(:expose_event) {
  cairo_context = @drawing_area.window.create_cairo_context
  # ========================================================================= #
  # Draw the rectangle next.
  # ========================================================================= #
  cairo_context.rectangle(
    # x-position, ..., y-position, width
    2, 2, 80, 50
  )
  cairo_context.set_source_rgb(0.2, 0.6, 0.6)
  cairo_context.fill
}

vbox.pack_start(@drawing_area, false, false, 40)
window.add(vbox)
window.set_size_request(740, 340)
window.move(0, 0)
window.show_all
Gtk.main