#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gir_ffi-gtk3'

Gtk.init

# ========================================================================= #
# Do the gtk-specific requires after Gtk.init
# ========================================================================= #
require 'gtk_paradise/core_classes/style_context.rb'
#require 'gtk_paradise/core_classes/tree_view.rb'

# ========================================================================= #
# === Gtk.simple_text
# ========================================================================= #
module Gtk
  def self.simple_text(i = '')
    return Gtk::Label.new(i)
  end
end

# ========================================================================= #
# Add window.
# ========================================================================= #
window = Gtk::Window.new(:toplevel)
window.resize(640, 480)
window.signal_connect('destroy') { Gtk.main_quit }

# ========================================================================= #
# Add treeview.
# ========================================================================= #
tree_view = Gtk::TreeView.new
#tree_view.do_use_clickable_headers
#tree_view.rubber_banding
# pp tree_view.methods.sort

# ========================================================================= #
# Add store.
# ========================================================================= #
ls = Gtk::ListStore.new([GObject::TYPE_STRING])
tree_view.set_model(ls)

# lab = Gtk::Label.new('Name')
lab = Gtk.simple_text('Name')
lab.show
rend = Gtk::CellRendererText.new

# ========================================================================= #
# Add column.
# ========================================================================= #
tree_view_column = Gtk::TreeViewColumn.new
tree_view_column.set_widget(lab)
tree_view_column.pack_start(rend, true)
tree_view_column.add_attribute(rend, 'text', 0)
tree_view.append_column(tree_view_column)
# tree_view.add_mnemonic_label("T")
tree_view.border_width = 120
tree_view.enable_grid_lines = 1
#tree_view.hadjustment = 0.5
tree_view.halign = 0.5
tree_view.headers_clickable = true
tree_view.headers_visible = true
tree_view.level_indentation = 3
tree_view.margin = 15
tree_view.rubber_banding = true
tree_view.set_has_tooltip(true)
tree_view.set_tooltip_text('This is just a tooltip example.')
#pp tree_view.state_flags


colour = Gdk::Color.new
colour.green = 55
colour.red = 55
colour.blue = 55
# width = tree_view.root_window.width
# pp width

# tree_view.override_background_color(:normal  , Gdk::Color.new(6400, 6400, 6440))
# tree_view.override_background_color(:prelight,   Gdk::Color.new(6400, 3400, 6440))
# tree_view.override_background_color(:active,  Gdk::Color.new(6400, 1400, 6440))

# pp tree_view.events

# pp ::Gtk::StyleProvider.constants.sort
# pp '^^^'
# style_context = Gtk.style_context_provider(:default, false)
# pp style_context

# ========================================================================= #
# Add rows.
# ========================================================================= #
iter = ls.append
ls.set_value(iter, 0, 'Kasper')

iter = ls.append
ls.set_value(iter, 0, 'Christina')
iter = ls.append
ls.set_value(iter, 0, 'Peter')
window.add(tree_view)
tree_view.show
window.show
Gtk.main