#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk2.rb'

# ========================================================================= #
# Add window.
# ========================================================================= #
win = Gtk::Window.new(:toplevel)
win.resize(640, 480)
win.signal_connect('destroy') { Gtk.main_quit }

# ========================================================================= #
# Add the treeview.
# ========================================================================= #
tv = Gtk.treeview # ::TreeView.new

# ========================================================================= #
# Add store.
# ========================================================================= #
ls = Gtk::ListStore.new([GObject::TYPE_STRING])
tv.set_model(ls)

# ========================================================================= #
# === Gtk.simple_text
# ========================================================================= #
module Gtk
  def self.simple_text(i = '')
    return Gtk::Label.new(i)
  end
end

# lab = Gtk::Label.new('Name')
lab = Gtk.simple_text('Name')
rend = Gtk::CellRendererText.new

# ========================================================================= #
# Add column.
# ========================================================================= #
col = Gtk::TreeViewColumn.new
col.set_widget(lab)
col.pack_start(rend, true)
col.add_attribute(rend, 'text', 0)

lab.show

tv.append_column(col)

# Add rows.
iter = ls.append
ls.set_value(iter, 0, 'Kasper')

iter = ls.append
ls.set_value(iter, 0, 'Christina')

win.add tv
tv.show

win.show

Gtk.main