#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Based on the 'Hello world' Gtk+ tutorial example at
#
#   https://library.gnome.org/devel/gtk-tutorial/2.90/c39.html#SEC-HELLOWORLD
#
# =========================================================================== #
require 'gtk_paradise/require_gtk2.rb'

alias e puts

win = Gtk::Window.new(:toplevel)
win.signal_connect('delete-event') {
  e 'delete event occured'
  true
}

win.signal_connect('destroy') { Gtk.main_quit }
win.border_width = 10

button = Gtk::Button.new_with_label('Hello World')
button.signal_connect('clicked') { win.destroy }

win.add(button)
button.show
win.show

Gtk.main