#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gir_ffi_gtk3'

alias e puts

require 'gtk_paradise/core_classes/list_store.rb'

# =========================================================================== #
# Add window.
# =========================================================================== #
win = Gtk::Window.new(:toplevel)
win.resize(640, 480)
win.signal_connect('destroy') { Gtk.main_quit }
win.move(0, 0)

# =========================================================================== #
# Add treeview.
# =========================================================================== #
tv = Gtk::TreeView.new

# =========================================================================== #
# Add store.
# =========================================================================== #
ls = Gtk::ListStore.new([GObject::TYPE_STRING])
tv.set_model(ls)

# =========================================================================== #
# === Gtk.simple_text
# =========================================================================== #
module Gtk
  def self.simple_text(i = '')
    return Gtk::Label.new(i)
  end
end

# lab = Gtk::Label.new('Name')
lab = Gtk.simple_text('Name')
rend = Gtk::CellRendererText.new

# =========================================================================== #
# Add column.
# =========================================================================== #
tree_view_column = Gtk::TreeViewColumn.new
tree_view_column.set_widget(lab)
tree_view_column.pack_start(rend, true)
tree_view_column.add_attribute(rend, 'text', 0)

lab.show

tv.append_column(tree_view_column)

# =========================================================================== #
# Add rows next:
# =========================================================================== #
ls.append_this_string('Kasper')
ls.append_this_string('Christina')
ls.append_this_string('Karl')

vbox = Gtk::Box.new(:vertical, 0)
vbox.add(tv)
button = Gtk::Button.new_with_label('OK')
button.signal_connect('clicked') {
  e 'OK'
}
vbox.add(button)
vbox.show_all
win.add(vbox)
tv.show
win.show
win.move(0, 0)

Gtk.main