#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

Width, Height = if ARGV.size == 2
  ARGV.map(&:to_i)
else
  [1000, 700]
end

Max_r, Min_r = 40, 10
ColorMax = 65535
MaxNum = 60


class Circle
  def initialize(ob)
    @slot = ob
    @width, @height = Width, Height
    renewal
    @y = rand(@height)
  end
  attr_reader :height
  attr_writer :y
  
  def renewal
    @width, @height = @slot.get_window_size
    @max_r = rand(Max_r - Min_r) + Min_r
    @x = rand(@width)
    @y = -rand(@max_r)
    @color = [rand(ColorMax), rand(ColorMax), rand(ColorMax)]
    @fall_step = 1 + rand * 3
    @r = 1
    @r_step = rand * 0.2 + 0.8
  end

  def paint
    @slot.color(@color[0], @color[1], @color[2])
    @slot.circle(true, @x, @y, @r)
    @y += @fall_step
    @r += @r_step
    @r_step *= -1 if @r > @max_r or @r < 1
    renewal if @y > @height + Max_r
    true
  end
end

Drawing.app(width: Width, height: Height, resizable: true) {
  circles = []
  MaxNum.times {circles << Circle.new(self)}
  black = color(0, 0, 0)
  
  draw do
    clear(black)
  end

  timer(60) do
    clear(black)
    circles.each(&:paint)
  end

  window_changed do
    clear(black)
    circles.each do |c|
      c.renewal
      c.y = rand(c.height)
      c.paint
    end
  end
}