#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

Width, Height = 500, 500

Drawing.app(width: Width, height: Height) {
  draw {
    clear
    
    color(0, 65535, 0)
    r = Width / 2
    circle(false, 0, r, r)
    circle(false, 2 * r, r, r)
    
    (1..9).to_a.combination(2) do |p, q|
      x = p / q.to_f
      y = 1 / (2 * q ** 2).to_f
      wx, wy = Width * x, Height * y
      circle(false, wx, Height - wy, wy)
    end
  }
}