#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

R = 7
Width, Height = 500, 500

Drawing.app(width: Width, height: Height) {
  draw {
    clear
  }

  p = Vector[0, 0]
  np = p
  deg = 90
  r = 0
  step = 1.5
  
  b_line = lambda do |p1, p2|
    l = (p2 - p1).r
    pt = p1
    0.upto(l) do
      color(0, 65535, 0)
      arc(true, Width / 2 + pt[0] - R, Height / 2 - pt[1] - R, R * 2, R * 2, 0, 64 * 360)
      pt += (p2 - p1) / l
    end
  end
  
  id = timer(50) do
    b_line.call(p, np)
    
    p = np
    θ = Math::PI * deg / 180
    np = Vector[Math.cos(θ), Math.sin(θ)] * r
    r += step
    step_d = 20 - r / 35
    deg -= step_d
    timer_stop(id) if r > 220
    true
  end
}