#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

Drawing.app {
  draw { clear }

  po = Vector[0, 150]
  θ = Math::PI / 50
  a = Matrix[
    [Math.cos(θ), -Math.sin(θ)], [Math.sin(θ), Math.cos(θ)]
  ]
  
  timer(20) {
    clear
    color(0, 65535, 0)
    star(false, 150, 150, 150 + po[0], 150 - po[1])
    po = a * po
  }
}