#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

L = 400
C_MAX = 65536

class Field

  attr_reader :x
  attr_reader :y

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    @x = rand(L)
    @y = rand(L)
    n = Vector[rand, rand]
    @n = [n[0] * 2 / n.norm, n[1] * 2 / n.norm]
  end

  # ========================================================================= #
  # === next
  # ========================================================================= #
  def next
    @x, @y = @x + @n[0], @y + @n[1]
    @n[0] = -@n[0] if @x < 2 or @x >= L - 2
    @n[1] = -@n[1] if @y < 2 or @y >= L - 2
  end
end

class Color

  # ========================================================================= #
  # === C_STEP
  # ========================================================================= #
  C_STEP = 1000

  attr_reader :x
  attr_reader :y
  attr_reader :z

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    run if run_already
  end
  
  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    @x = rand(C_MAX)
    @y = rand(C_MAX)
    @z = rand(C_MAX)
    cn = Vector[rand, rand, rand]
    @cn = [cn[0] / cn.norm, cn[1] / cn.norm, cn[2]/ cn.norm]
  end

  # ========================================================================= #
  # === next
  # ========================================================================= #
  def next
    @x, @y, @z = @x + @cn[0] * C_STEP, @y + @cn[1] * C_STEP, @z + @cn[2] * C_STEP
    @cn[0] = -@cn[0] if @x < C_STEP or @x >= C_MAX - C_STEP
    @cn[1] = -@cn[1] if @y < C_STEP or @y >= C_MAX - C_STEP
    @cn[2] = -@cn[2] if @z < C_STEP or @z >= C_MAX - C_STEP
    init if rand < 0.001
  end

end

pos = Field.new
col = Color.new

Drawing.app(width: L, height: L) {
  draw { clear }

  timer(20) {
    color(col.x.to_i, col.y.to_i, col.z.to_i)
    arc(true, pos.x.to_i + 2, pos.y.to_i + 2, 4, 4, 0, 64 * 360)
    pos.next
    col.next
    true
  }
}