#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

HEIGHT_AND_WIDTH = 400
R1 = 150
R2 = (HEIGHT_AND_WIDTH - R1 * 2) / 2 - 5
STP1 = (Math::PI / 180) * 0.5
STP2 = (Math::PI / 180) * 10

Drawing.app(width: HEIGHT_AND_WIDTH, height: HEIGHT_AND_WIDTH) {
  # ========================================================================= #
  # === TIMER_ANIMATION_SPEED
  # ========================================================================= #
  TIMER_ANIMATION_SPEED = 20
  draw {
    clear(color(5000, 0, 10000))
  }

  i = 0
  
  # ========================================================================= #
  # The higher the timer-value, the faster the animation.
  # ========================================================================= #
  id = timer(TIMER_ANIMATION_SPEED) {
    x = HEIGHT_AND_WIDTH / 2 + (R1 * Math.cos(STP1 * i) + R2 * Math.cos(STP2 * i))
    y = HEIGHT_AND_WIDTH / 2 - (R1 * Math.sin(STP1 * i) + R2 * Math.sin(STP2 * i))
    color(0, 65535, 0)
    arc(false, x, y, 3, 3, 0, 64 * 360)
    i += 1
    timer_stop(id) if STP1 * i > Math::PI * 2
    true
  }
}