#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

L = 300
O = L / 2
R = 140
step = 20

i = 0

Drawing.app(width: L, height: L) {
  N_TIMES = 5
  draw {
    clear
    color(0x87 * 256, 0xce * 256, 0xeb * 256)   #skyblue
    arc(false, O - R, O - R, R * 2, R * 2, 0, 64 * 360)
  }
  
  id = timer(500) do
    ar = []
    θ = i * step * Math::PI / 180
    x = R * Math.cos(θ)
    y = R * Math.sin(θ)
    ar << [O + x, O - y]
    N_TIMES.times {
      x, y = -y, x
      ar << [O + x, O - y]
    }
    color(0x22 * 256, 0x8b * 256, 0x22 * 256)    #forestgreen
    polygon(false, ar)
    i += 1
    timer_stop(id) if i * step > 180
    true
  end
}