#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

include Math

WIDTH  = 600
HEIGHT = 400
V0     = 10.0
A      = 0.75
G      = 5.0

v = lambda {|n|
  - A ** n * sqrt(2 * G * HEIGHT)
}

t = lambda { |n|
  if n.zero?
    sqrt(2 * HEIGHT / G)
  else
    array = [1]
    n.times {|i|
      array << 2 * A ** (i + 1)
    }
    sqrt(2 * HEIGHT / G) * array.inject(:+)
  end
}

y = lambda { |n, t1|
  if n.zero?
    HEIGHT - G * t1 ** 2 / 2
  else
    t2 = t1 - t.call(n - 1)
    - v.call(n) * t2 - G * t2 ** 2 / 2
  end
}

x = lambda {|t1| V0 * t1}

num = lambda { |tm|
  1000.times {|i| return i if tm <= t.call(i)}
}

i = 0

Drawing.app(width: WIDTH, height: HEIGHT) {
  draw { clear }

  id = timer(20) {
    tm = i / V0
    x1 = x.call(tm)
    y1 = HEIGHT - y.call(num[tm], tm)
    color(65535, 0, 0)
    arc(false, x1, y1, 4, 4, 0, 64 * 360)
    timer_stop(id) if i >= WIDTH
    i += 1
  }

}