#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_module'
# =========================================================================== #
require 'gtk3'

class CairoRectangles < Gtk::Window

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    set_title 'Colours'
    signal_connect(:destroy){ 
      Gtk.main_quit 
    }
    init_ui
    set_default_size 360, 100
    set_window_position :center
    show_all
  end
  
  # ========================================================================= #
  # === init_ui
  # ========================================================================= #
  def init_ui
    @darea = Gtk::DrawingArea.new  
    @darea.signal_connect(:draw) { on_draw }
    add(@darea)
  end
  
  # ========================================================================= #
  # === on_draw
  # ========================================================================= #
  def on_draw
    cr = @darea.window.create_cairo_context  
    draw_colors cr
  end 

  # ========================================================================= #
  # === draw_colors
  #
  # Draw three rectangles.
  # ========================================================================= #
  def draw_colors(i)
    i.set_source_rgb 0.2, 0.23, 0.9
    i.rectangle 10, 15, 90, 60 # rectangle 1
    i.fill

    i.set_source_rgb 0.9, 0.1, 0.1
    i.rectangle 130, 15, 90, 60 # rectangle 2
    i.fill

    i.set_source_rgb 0.4, 0.9, 0.4
    i.rectangle 250, 15, 90, 60 # rectangle 3
    i.fill
  end

end

if __FILE__ == $PROGRAM_NAME
  CairoRectangles.new
  Gtk.main
end