#!/usr/bin/ruby -w
require 'gtk2'
require 'cairo'

class RgtkCairo < Gtk::VBox
  def initialize
    super
    drawing_area = Gtk::DrawingArea.new
    add(drawing_area)
    drawing_area.set_size_request(500, 200)
    drawing_area.signal_connect(:expose_event) { |widget, event|
      cairo_context = widget.window.create_cairo_context
      # fill background with a random number
      number = 0+(rand(100.0)/100.0)
      cairo_context.set_source_rgba(number, number, number)
      cairo_context.paint
      # create the shape next:
      cairo_context.set_line_width(3)
      cairo_context.move_to(50,21) # Start here.
      cairo_context.curve_to(10, 20, 30, 40, 50, 60)
      cairo_context.line_to(150, 150)
      cairo_context.line_to(50, 150)
      cairo_context.close_path
      cairo_context.set_source_rgb(0.0, 0.0, 0.0)
      cairo_context.fill_preserve    
      cairo_context.set_source_rgb(1.0, 0.0, 0.0)
      cairo_context.set_line_join(Cairo::LINE_JOIN_MITER)
      cairo_context.stroke
    }
    self.show_all
  end

end

if __FILE__ == $PROGRAM_NAME
  x = RgtkCairo.new
  r = Gtk::Window.new
  r.add(x)
  r.move(0, 0)
  r.show_all
  Gtk.main
end