#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === CairoTransparentRectangles
#
# In computer graphics, transparency effects can be achieved using
# alpha compositing. 
#
# Usage example:
#
#   CairoTransparentRectangles.new(ARGV)
#
# =========================================================================== #
# require 'gtk_paradise/examples/cairo_transparent_rectangles.rb'
# =========================================================================== #
require 'gtk3'

class CairoTransparentRectangles < Gtk::Window # === CairoTransparentRectangles

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    run if run_already
  end

  # ========================================================================= #
  # === initialize_the_drawing_area
  # ========================================================================= #
  def initialize_the_drawing_area
    @darea1 = Gtk::DrawingArea.new
    @darea1.signal_connect(:draw) { on_draw1 }

    @darea2 = Gtk::DrawingArea.new
    @darea2.signal_connect(:draw) { on_draw2 }
  end

  # ========================================================================= #
  # === on_draw1
  # ========================================================================= #
  def on_draw1
    cr = @darea1.window.create_cairo_context
    draw_rectangles(cr)
  end

  # ========================================================================= #
  # === on_draw2
  # ========================================================================= #
  def on_draw2
    cr = @darea2.window.create_cairo_context
    draw_rectangles(cr, 1)
  end

  # ========================================================================= #
  # === draw_rectangles
  #
  # This method will draw ten rectangles with different levels of
  # transparency.
  # ========================================================================= #
  def draw_rectangles(
      cr, n_times = 10
    )
    n_times.times {|i|
      cr.set_source_rgba(0, 0, 1, i * 0.1)
      cr.rectangle(50*i, 20, 40, 40)
      cr.fill
    }
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    set_title 'Transparent rectangles'
    signal_connect(:destroy) { Gtk.main_quit }
    initialize_the_drawing_area
    set_default_size(590, 90)
    set_window_position :center
    # vbox = Gtk::Box.new(:vertical)
    # vbox.add(@darea1)
    # vbox.add(@darea2)
    # vbox.show_all
    # add(vbox)
    # vbox.add(@darea2)
    add(@darea1)
    show_all
  end

end

if __FILE__ == $PROGRAM_NAME
  CairoTransparentRectangles.new
  Gtk.main
end # cairo_transparent_rectangles.rb