#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Unfortunately this currently only works for gtk2. If anyone knows how
# to write this for gtk3 as well, let me know.
# =========================================================================== #
require 'gtk2'

# =========================================================================== #
# The Diagram
# =========================================================================== #
class Diagram < Gtk::DrawingArea

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    set_size_request(400, 400)
    signal_connect(:expose_event) { |widget, event|
      cr = self.window.create_cairo_context
      cr.rectangle(
        event.area.x,
        event.area.y,
        event.area.width,
        event.area.height
      )
      cr.clip
      draw(cr)
      false
    }
  end

  # ========================================================================= #
  # === draw
  # ========================================================================= #
  def draw(cr)
    xcenter = allocation.x + allocation.width  / 2
    ycenter = allocation.y + allocation.height / 2
    # ======================================================================= #
    # Provide some information to the user next:
    # ======================================================================= #
    puts "origin: (#{allocation.x}, #{allocation.y}) size:(#{allocation.width}, #{allocation.height})"
    # ======================================================================= #
    # Draw a circle next.
    # ======================================================================= #
    cr.circle(xcenter, ycenter, [allocation.width / 2, allocation.height / 2].min)
    cr.stroke
    cr.move_to(allocation.x, allocation.y)
    cr.line_to(allocation.x+allocation.width, allocation.y+allocation.height)
    cr.move_to(allocation.x+allocation.width, allocation.y)
    cr.line_to(allocation.x, allocation.y+allocation.height)
    cr.stroke
  end

end

class App < Gtk::Window

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super
    move(0, 0)
    self.title = 'Cairo'
    signal_connect(:delete_event) { quit }
    signal_connect(:destroy)      { quit }
    add(hbox = Gtk::VBox.new)
    hbox.pack_start Diagram.new, true, true
    hbox.pack_start Gtk::Label.new('cairo'), false, false
    hbox.pack_start Gtk::Label.new('cairo'), false, false
    run
  end

  # ========================================================================= #
  # === quit
  # ========================================================================= #
  def quit
    Gtk.main_quit
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    show_all
    Gtk.main
  end

end

if __FILE__ == $PROGRAM_NAME
  App.new  
end # rb test_cairo.rb