#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::WidgetsDescribedInAYamlFile
# =========================================================================== #
# require 'gtk_paradise/example/advanced/advanced_css_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class WidgetsDescribedInAYamlFile < ::Gtk::BaseModuleBox # === Gtk::WidgetsDescribedInAYamlFile

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Widgets described in a yaml file example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '60% or 1000px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '40% or 6200px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === USE_THESE_CSS_RULES
  # ========================================================================= #
  USE_THESE_CSS_RULES = '
.blightgreen5 { border: 8px solid lightgreen; }
.bblack5      { border: 8px solid black; }
.bgreen5      { border: 8px solid green; }



.box_shadow1 {
  box-shadow: inset 1px 0 alpha(tomato, 0.10),
              inset 0 1px alpha(tomato, 0.12),
              inset -1px 0 alpha(tomato, 0.15),
              inset 0 -1px alpha(tomato, 0.05);
}


.background_for_a_fancy_hover_button_effect {
  background: rgb(242,93,9);
  background: linear-gradient(180deg, rgba(242,93,9,1) 0%, rgba(243,255,0,1) 100%);
  margin: 30px;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0,0,0,.5);
}

.background_for_a_fancy_hover_button_effect button {
  background: palevioletred;
  color: black;
  border: 4px solid gold;
  transition: all 600ms ease-in-out;
}

.background_for_a_fancy_hover_button_effect button:hover {
  box-shadow: 0 0 10px steelblue;
  padding: 10px 20px;
  font-size: 150%;
}

'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
    # ======================================================================= #
    # Add more CSS next:
    # ======================================================================= #
    more_CSS USE_THESE_CSS_RULES
    # ======================================================================= #
    # === @widget_dataset
    #
    # Load the dataset from the file all_widgets.yml.
    # ======================================================================= #
    target_file = project_yaml_directory?+'experimental/all_widgets.yml'
    if File.exist?(target_file)
      @widget_dataset = YAML.load_file(
        target_file
      )
    end
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
    # ======================================================================= #
    # The next line swallows information, so we may have to leave it
    # commented out:
    # ======================================================================= #
    # run_in_background_if_is_on_roebe?
  end

  # ========================================================================= #
  # === do_something1
  # ========================================================================= #
  def do_something1
    e 'something 1'
  end

  # ========================================================================= #
  # === do_something2
  # ========================================================================= #
  def do_something2
    e 'something 2'
  end

  # ========================================================================= #
  # === do_something3
  # ========================================================================= #
  def do_something3
    e 'Show a cat image here.'
  end

  # ========================================================================= #
  # === do_something4
  # ========================================================================= #
  def do_something4
    e 'Show a mouse image here.'
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(
      left_aligned_label('Widget set described via a yaml file.')
    )
    outer_box = vbox
    button_test = button('Test')
    button_test.on_clicked {
      e 'A button was clicked.'
    }
    box1 = vbox
    box1.css_class('background_for_a_fancy_hover_button_effect')
    box1.show_all
    box1.add(button_test)
    outer_box.add(box1)
    automatically_create_widgets_based_on_this_dataset(
      @widget_dataset
    )
    # button2 = automatically_created_widgets?[:buttons][:button2]
    # box.minimal(button2, 6)
    # ======================================================================= #
    # The next clause will add all these widgets that are
    # created by the above line - at the least buttons: 
    # ======================================================================= #
    automatically_created_widgets?[:buttons].each_pair {|id, this_widget|
      outer_box.minimal(this_widget, 6)
    }
    automatically_created_widgets?[:entries].each_pair {|id, this_widget|
      outer_box.minimal(this_widget, 6)
    }
    minimal(outer_box, 10)
  end

  # ========================================================================= #
  # === Gtk::WidgetsDescribedInAYamlFile.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    _ = ::Gtk::WidgetsDescribedInAYamlFile.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::WidgetsDescribedInAYamlFile.run
end