#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::NotebookWithTabExample
# =========================================================================== #
# require 'gtk_paradise//gtk3/023_image_in_label_example.rb'
# Gtk::NotebookWithTabExample.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'
require 'gtk_paradise/widgets/gtk3/notebook_tab_with_icon/notebook_tab_with_icon.rb'

module Gtk

class NotebookWithTabExample < ::Gtk::BaseModuleBox # === Gtk::NotebookWithTabExample 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Image in label example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '70% or minimum 600px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '35% or minimum 400px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    handle_CSS
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === handle_CSS
  # ========================================================================= #
  def handle_CSS
    use_gtk_paradise_project_css_file
    # ======================================================================= #
    # The purpose of the next chunk of code is to assign a yellow background
    # to the text-view in use.
    # ======================================================================= #
    more_CSS '
      .custom_text_view text {
        background-color: #fffae2;
        background-position: center;
        background-image:url(
          "/home/x/programming/ruby/src/rpg_paradise/lib/rpg_paradise/images/misc/parchment_background.png"
        );
      }
    '
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    0
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    text_buffer = create_text_buffer
    text_buffer.set_text("Hello world!\n")
    text_buffer.append_this_image(
      project_base_directory?+
      'images/icons/icon_smile.gif'
    )
    text_buffer.append_this_image(:smiley) # And an alias to the ^^^ above.
    text_buffer.append_this_image(:smiley)
    text_buffer.append_this_image(:smiley)
    text_buffer.smiley
    text_buffer.smiley
    text_buffer.smiley
    text_view   = create_text_view(text_buffer)
    scrolled_window = create_scrolled_window(text_view)
    scrolled_window.width_height(500, 400)
    scrolled_window.css_class('custom_text_view')
    minimal(
      scrolled_window
    )
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
    # ======================================================================= #
    # === @notebook
    # ======================================================================= #
    @notebook = default_notebook
    @notebook.on_top
  end

  # ========================================================================= #
  # === do_action_associated_with_the_icon_pressed              (clicked tag)
  # ========================================================================= #
  def do_action_associated_with_the_icon_pressed(i = nil)
    if i
      # ===================================================================== #
      # In this case we must find the correct tab-id, in order to
      # remove it.
      # ===================================================================== #
      e 'Not yet implemented.'
    end
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
    index = 0
    _ = ::Gtk::NotebookTabWithIcon.new(:close_picture, '#1') { :right_side }
    _.set_parent_widget(self)
    @notebook.append_page(text('Content #'+(index+1).to_s), _)
    index += 1
    _ = ::Gtk::NotebookTabWithIcon.new(:close_picture, '#2') { :right_side }
    _.set_parent_widget(self)
    @notebook.append_page(text('Content #'+(index+1).to_s), _)
    index += 1
    _ = ::Gtk::NotebookTabWithIcon.new(:close_picture, '#3') { :right_side }
    _.set_parent_widget(self)
    @notebook.append_page(text('Content #'+(index+1).to_s), _)
    index += 1
    _ = ::Gtk::NotebookTabWithIcon.new(:close_picture, '#4') { :right_side }
    _.set_parent_widget(self)
    @notebook.append_page(text('Content #'+(index+1).to_s), _)
    index += 1
    _ = ::Gtk::NotebookTabWithIcon.new(:close_picture, '#5') { :right_side }
    _.set_parent_widget(self)
    @notebook.append_page(text('Content #'+(index+1).to_s), _)
    index += 1

    @notebook.can_be_rearranged
    minimal(@notebook)
    set_use_this_font(:hack_22)
  end

  # ========================================================================= #
  # === Gtk::NotebookWithTabExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::NotebookWithTabExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::NotebookWithTabExample.run
end