#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::AutogeneratedCSSRoundedBorders
# =========================================================================== #
# require 'gtk_paradise/examples/gtk3/gtk3_standalone/gtk3_standalone.rb'
# Gtk::AutogeneratedCSSRoundedBorders.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class AutogeneratedCSSRoundedBorders < ::Gtk::BaseModuleBox # === Gtk::AutogeneratedCSSRoundedBorders 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Autogenerated CSS rounded borders.'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '25% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(
      left_aligned_label('This will test rounded borders.'), 4
    )

    hbox2 = create_hbox
    small_hbox1 = create_hbox
    small_hbox1.minimal(bold_text('!!! OK for hbox2 !!!'))
    hbox2.minimal(small_hbox1)
    # Put down rounded borders here.
    hbox2.rounded_border('4px', :default, '12px solid tomato')
    minimal(hbox2, 58)

    hbox3 = create_hbox
    hbox3 << bold_text('!!! OK for hbox3 !!!')
    hbox3.css_class('border12')
    minimal(hbox3, 10)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
    # show_the_CSS_rules
  end

  # ========================================================================= #
  # === Gtk::AutogeneratedCSSRoundedBorders.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = Gtk::AutogeneratedCSSRoundedBorders.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::AutogeneratedCSSRoundedBorders.run
end