#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/example/advanced/018_coloured_text_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ColouredTextExample < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Advanced CSS example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '40% or minimum 450px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '35% or minimum 350px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_25

  # ========================================================================= #
  # === TEXT
  #
  # This is our text containing the HTML-like tagged colours.
  # ========================================================================= #
  TEXT = '

<green>Hello</green><span foreground="blue"> world!</span>

<green>green</green>
<tomato>tomato</tomato>
<blue>blue</blue>
<steelblue>steelblue</steelblue>


<steelblue>longer text</steelblue>
longer text

<green>yo</green><blue> there</blue>

'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    8
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    4
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    outer_vbox = gtk_vbox
    _ = replace_with_proper_tags(TEXT)
    outer_vbox.maximal(_, 5)
    scrolled_window = gtk_scrolled_window(outer_vbox) { :top_to_bottom_always }
    maximal(scrolled_window)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::ColouredTextExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ColouredTextExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ColouredTextExample.run
end # gtk_coloured_text_example