#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Test

module GUI

module Gtk

class PopupExample < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:vertical)
    reset
    run
  end

  # ========================================================================= #
  # === context_menu_action_number1
  # ========================================================================= #
  def context_menu_action_number1
    e 'This is context menu action 1.'
  end

  # ========================================================================= #
  # === context_menu_action_number2
  # ========================================================================= #
  def context_menu_action_number2
    e 'This is context menu action 2.'
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ====================================================================== #
    # === @configuration
    # ====================================================================== #
    @configuration = [true, __dir__, infer_the_namespace]
    # ====================================================================== #
    # === @context_menu
    # ====================================================================== #
    @context_menu = create_context_menu(self) {{
      # n_entries: 12,
      actions: {
        'FoobarAction1': :context_menu_action_number1,
        'FoobarAction2': :context_menu_action_number2
      }
    }}
    @context_menu.css_class(
      'bblack6_and_padding'
    )
    use_gtk_paradise_project_css_file
    more_css '
    .bblack6_and_padding { border: 6px solid black; padding: 25px; }
    '
    apply_the_CSS_rules
    # show_the_CSS_rules # This is mostly just for debugging.
    increase_the_font_size
  end

  # ========================================================================= #
  # === context_menu?
  # ========================================================================= #
  def context_menu?
    @context_menu
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    @button = gtk_button('Right click on me, with the mouse button.')
    @button.disallow_resizing
    @button.set_size_request(300, 300)
    @button.bblack2
    maximal(@button)
  end

  # ========================================================================= #
  # === button?
  # ========================================================================= #
  def button?
    @button
  end

  # ========================================================================= #
  # === Test::GUI::Gtk::PopupExample.run
  # ========================================================================= #
  def self.run
    ::Test::GUI::Gtk::PopupExampleModule.run
  end

end; end; end; end

if __FILE__ == $PROGRAM_NAME
  r = Gtk.run
  _ = Test::GUI::Gtk::PopupExample.new
  r << _
  r.enable_context_menu
  r.signal_connect(:button_press_event) { |widget, event|
    if ::Gtk.right_mouse_click?(event) # right mouse click event.
      _.context_menu?.popup_based_on_this_event(event)
    end
  }
  r.top_left_then_run
end